<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Contact;
use App\Models\News;
use Illuminate\Support\Facades\Request;

class BrandController extends Controller
{
    public function index()
    {
        $brands = Brand::all();
        $preschoolBrands = Brand::Where('type', Controller::PRESCHOOL)->get();
        $teensBrands = Brand::Where('type', Controller::TEENS)->get();
        $animeBrands = Brand::Where('type', Controller::ANIME)->get();
        $priorityBrands = Brand::where('primary', 1)->get();
        $keyWords = Brand::all()->pluck('name');
        $new = News::all();
        $contact = Contact::first();
        return view('ourbrands')->with([
            'brands' => $brands,
            'preschoolBrands' => $preschoolBrands,
            'teensBrands' => $teensBrands,
            'animeBrands' => $animeBrands,
            'keyWords' =>  strip_tags($keyWords),
            'contact' => $contact,
            'news' => $new,
            'priorityBrands' => $priorityBrands
        ]);
    }

    public function brandDetails()
    {
        $brands = Brand::all();
        $id = Request::segment(2);
        $details = Brand::findOrFail($id);
        $contact = Contact::first();
        $new = News::all();
        $priorityBrands = Brand::where('primary', 1)->get();
        return view('brand')->with(
            [
                'id' => $id,
                'details' => $details,
                'brands' => $brands,
                'contact' => $contact,
                'news' => $new,
                'priorityBrands' => $priorityBrands
            ]
        );
    }
}
