<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Contact;
use App\Models\Count;
use App\Models\FreeFire;
use App\Models\Message;
use App\Models\News;
use App\Models\Partner;
use App\Models\Service;
use App\Models\Slider;
use App\Models\Video;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function index()
    {
        $brands = Brand::all();
        $priorityBrands = Brand::where('primary', 1)->get();
        $lastBrand = Brand::where('primary', 1)->orderBy('id', 'desc')->first();
        $priorityBrandsWithoutLast = Brand::where('primary', 1)->orderBy('id', 'desc')
            ->take(DB::table('brands')->where('primary', 1)->count() - 1)->get();
        $partners = Partner::all();
        $count = Count::first();
        $contact = Contact::first();
        $keyWords = Brand::all()->pluck('name');
        $new = News::all();
        $videos = Video::inRandomOrder()->get();
        $services = Service::all();
        return view('index')->with([
            'brands' => $brands,
            'partners' => $partners,
            'count' => $count,
            'contact' => $contact,
            'keyWords' =>  strip_tags($keyWords),
            'news' => $new,
            'videos' => $videos,
            'services' => $services,
            'priorityBrands' => $priorityBrands,
            'lastBrand' => $lastBrand,
            'priorityBrandsWithoutLast' => $priorityBrandsWithoutLast
        ]);
    }
}
