<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Contact;
use App\Models\News;
use App\Models\Partner;
use Illuminate\Support\Facades\Request;

class NewController extends Controller
{
    public function index()
    {
        $brands = Brand::all();
        $partners = Partner::all();
        $new = News::all();
        $contact = Contact::first();
        $priorityBrands = Brand::where('primary', 1)->get();

        return view('new')->with([
            'news' => $new,
            'contact' => $contact,
            'brands' => $brands,
            'partners' => $partners,
            'priorityBrands' => $priorityBrands
        ]);
    }

    public function newDetails()
    {
        $brands = Brand::all();
        $id = Request::segment(2);
        $details = News::findOrFail($id);
        $contact = Contact::first();
        $new = News::all();
        $priorityBrands = Brand::where('primary', 1)->get();
        return view('new_details')->with(
            [
                'id' => $id,
                'details' => $details,
                'brands' => $brands,
                'contact' => $contact,
                'news' => $new,
                'priorityBrands' => $priorityBrands
            ]
        );
    }
}
