<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MessageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required|string|min:1',
            'email' => 'required|email:rfc,filter',
            'message' => 'required|string|min:1',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'please enter the name',
            'email.required' => 'please enter the email',
            'message.required' => 'please enter the message',
        ];
    }
}
