<?php

namespace App\Widgets;

use Arrilot\Widgets\AbstractWidget;
use Illuminate\Support\Str;
use App\Models\Brand;

class Brands extends AbstractWidget
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run()
    {
        $count = Brand::count();

        return view('voyager::dimmer', array_merge($this->config, [
            'icon'   => 'voyager-star',
            'title'  => "{$count} brands",
            'text'   => __('', ['count' => $count, 'string' => Str::lower('')]),
            'button' => [
                'text' => 'Brand',
                'link' => route('voyager.brands.index'),
            ],
            'image' => voyager_asset('images/widget-backgrounds/03.jpg'),
        ]));
    }

    /**
     * Determine if the widget should be displayed.
     *
     * @return bool
     */
    public function shouldBeDisplayed()
    {
        return true;
    }
}
