$(window).scroll(function () {
    var scrollTop = $(window).scrollTop();
    var eventFirstCol = scrollTop / 2.2 + "px";
    var eventSectCol = scrollTop / 10 + "px";
    var eventThirdtCol = scrollTop / 1.5 + "px";

    $(".first-col .img").css("transform", "translateY(" + eventFirstCol + ")");

    $(".second-col .img").css("transform", "translateY(" + eventSectCol + ")");

    $(".third-col .img").css("transform", "translateY(" + eventThirdtCol + ")");

    //   $('.first-col img').css('transform', 'translateY(' + eventThirdtCol + ')');

    $(".black-opacity").css({
        opacity: function () {
            var elementHeight = $(this).height(),
                opacity =
                    (1 - (elementHeight - scrollTop) / elementHeight) * 0.8 +
                    0.2;

            return opacity;
        },
    });
});

$.fn.isInViewport = function () {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();

    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();

    return elementBottom > viewportTop && elementTop < viewportBottom;
};

$(window).on("resize scroll", function () {
    $(".wrapp-overflow").each(function () {
        if ($(this).isInViewport()) {
            $(".wrapper:not(.not-front)").addClass("overflowed");
        } else {
            $(".wrapper:not(.not-front)").removeClass("overflowed");
        }
    });
});

jQuery(document).ready(function () {
    jQuery("#top-bar, #bottom-bar").owlCarousel({
        loop: true,
        items: 6,
        autoplay: true,
        slideTransition: "linear",
        autoplaySpeed: 5000,
        smartSpeed: 5000,
        center: true,
        dots: false,
        nav: false,
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 3,
            },
            1000: {
                items: 5,
            },
        },
    });
});

jQuery(document).ready(function () {
    jQuery("#logo-bar").owlCarousel({
        loop: true,
        dots: false,
        nav: false,
        items: 6,
        autoplay: true,
        slideTransition: "linear",
        autoplaySpeed: 1250,
        smartSpeed: 1250,
        center: true,
        responsive: {
            0: {
                items: 3,
            },
            600: {
                items: 4,
            },
            1000: {
                items: 5,
            },
        },
    });

    jQuery("#logo-bar").trigger("play.owl.autoplay", [50]);

    function setSpeed() {
        jQuery("#logo-bar").trigger("play.owl.autoplay", [1250]);
    }

    setTimeout(setSpeed, 250);
});

jQuery(document).ready(function () {
    jQuery("#brand-slider").owlCarousel({
        loop: true,
        dots: false,
        nav: true,
        responsiveClass: true,
        // autoplay: true,
        // slideTransition: "linear",
        // autoplaySpeed: 3250,
        // smartSpeed: 3250,
        center: true,
        // items: 1,
        responsive: {
            // 0: {
            //     items: 3,
            // },
            // 600: {
            //     items: 3,
            // },
            1000: {
                items: 1,
            },
        },
    });

    jQuery("#brand-slider").trigger("play.owl.autoplay", [1750]);

    function setSpeed() {
        jQuery("#brand-slider").trigger("play.owl.autoplay", [2750]);
    }

    setTimeout(setSpeed, 1750);
});

jQuery("#our-services").owlCarousel({
    loop: true,
    dots: false,
    nav: false,
    items: 6,
    autoplay: true,
    // slideTransition: 'linear',
    // autoplaySpeed: 1250,
    // smartSpeed: 1250,
    // center: true,
    responsive: {
        0: {
            items: 2,
        },
        600: {
            items: 4,
        },
        1000: {
            items: 6,
        },
    },
});

const inViewport = (elem) => {
    let allElements = document.getElementsByClassName(elem);
    let windowHeight = window.innerHeight - 110;
    const elems = () => {
        for (let i = 0; i < allElements.length; i++) {
            let viewportOffset = allElements[i].getBoundingClientRect();
            let top = viewportOffset.top;
            if (top < windowHeight) {
                allElements[i].classList.add("in-viewport");
            } else {
                // allElements[i].classList.remove('in-viewport');
            }
        }
    };
    elems();
    window.addEventListener("scroll", elems);
};

inViewport("appear-case");

/*********/

var current = $(window).scrollTop();
var total = $(window).height() - current;
var ele = $(".brand-seg-title");
var currPosition = ele.position().left - ele.position().left / 5;
var trackLength = 300;
$(window).scroll(function (event) {
    current = $(window).scrollTop();
    // console.log({total:total,current:current});
    // console.log(current/total * 100);
    var newPosition = trackLength * (current / total);
    var crrTotal = (currPosition + newPosition) * -1;
    ele.css({ translate: crrTotal + "px" });
});

/****************** */

const cursor = document.querySelector("#cursor");
const cursorCircle = cursor.querySelector(".curs-circle");

const mouse = { x: -100, y: -100 };
const pos = { x: 0, y: 0 };
const speed = 0.1;
const updateCoordinates = (e) => {
    mouse.x = e.clientX;
    mouse.y = e.clientY;
};

window.addEventListener("mousemove", updateCoordinates);

function getAngle(diffX, diffY) {
    return (Math.atan2(diffY, diffX) * 180) / Math.PI;
}

function getSqueeze(diffX, diffY) {
    const distance = Math.sqrt(Math.pow(diffX, 2) + Math.pow(diffY, 2));
    const maxSqueeze = 0.15;
    const accelerator = 1500;
    return Math.min(distance / accelerator, maxSqueeze);
}

const updateCursor = () => {
    const diffX = Math.round(mouse.x - pos.x);
    const diffY = Math.round(mouse.y - pos.y);

    pos.x += diffX * speed;
    pos.y += diffY * speed;

    const angle = getAngle(diffX, diffY);
    const squeeze = getSqueeze(diffX, diffY);

    const scale = "scale(" + (1 + squeeze) + ", " + (1 - squeeze) + ")";
    const rotate = "rotate(" + angle + "deg)";
    const translate = "translate3d(" + pos.x + "px ," + pos.y + "px, 0)";

    cursor.style.transform = translate;
    cursorCircle.style.transform = rotate + scale;
};

function loop() {
    updateCursor();
    requestAnimationFrame(loop);
}

requestAnimationFrame(loop);

const cursorModifiers = document.querySelectorAll("[cursor-class]");

cursorModifiers.forEach((curosrModifier) => {
    curosrModifier.addEventListener("mouseenter", function () {
        const className = this.getAttribute("cursor-class");
        cursor.classList.add(className);
    });

    curosrModifier.addEventListener("mouseleave", function () {
        const className = this.getAttribute("cursor-class");
        cursor.classList.remove(className);
    });
});

/************/
