@extends('layout')
@section('title', $details['name'])
@section('keywords', $details['keywords'])
@section('description', $details['description'])
@section('content')
    <main>
        <section class="services dotted-bg">
            <div class="container">
                <div class="row brand-counter-web">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6 d-flex the-events-menu">
                        <div>
                            <span>
                                {{ $details['first_counter_name'] }}
                            </span>
                            <span>
                                {{ $details['first_counter_value'] }}
                            </span>
                        </div>
                        <div>
                            <span>
                                {{ $details['second_counter_name'] }}
                            </span>
                            <span>
                                {{ $details['second_counter_value'] }}
                            </span>
                        </div>
                        <div>
                            <span>
                                {{ $details['third_counter_name'] }}
                            </span>
                            <span>
                                {{ $details['third_counter_value'] }}
                            </span>
                        </div>
                    </div>
                    <div class="col-lg-3"></div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="brand-screen appear-case" style="opacity: 0;">
                            <a href="#" style="width: 100%;">
                                <video style="width: 100%;" autoplay loop muted
                                    poster={{ url('storage/' . $details['image']) }}>
                                    <source
                                        src={{ url('storage/' . json_decode($details['GIF'])[count(json_decode($details['GIF'])) - 1]->download_link) }}
                                        type="video/mp4">
                                </video>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="services dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="iconic-title">
                            <img src={{ url('storage/' . $details['logo']) }} alt="{{ $details['name'] }}">
                            <div>
                                <span class="it-1">{{ $details['name'] }}</span>
                                <span class="it-2">{{ $details['sub_title'] }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 pt-3 pb-5">
                        <h1>{{ $details['description'] }}</h1>
                    </div>
                </div>
                {{-- on mobile --}}
                <div class="row brand-counter-mob">
                    <div class="the-events-menu">
                        <div>
                            <span>
                                {{ $details['first_counter_name'] }} : {{ $details['first_counter_value'] }}
                            </span>
                        </div>
                        <div>
                            <span>
                                {{ $details['second_counter_name'] }} : {{ $details['second_counter_value'] }}
                            </span>
                        </div>
                        <div>
                            <span>
                                {{ $details['third_counter_name'] }} : {{ $details['third_counter_value'] }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="services dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 relative">
                        <div class="banner-text in-sections min-first text-center cus-sticky">
                            <div class="outlined appear-case"><span style="opacity: 0">WOW</span></div>
                            <div class="appear-case"><span style="opacity: 0">Factors</span></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="services">
                            @if ($details['first_factor_title'])
                                <div class="ser">
                                    <div class="ser-logo">
                                        <img src={{ url('assets/imgs/ser1.png') }} alt="Activation">
                                    </div>
                                    <div class="ser-content">
                                        <h2>{{ $details['first_factor_title'] }}</h2>
                                        <div>{{ $details['first_factor_desc'] }}</div>
                                    </div>
                                </div>
                            @endif

                            @if ($details['second_factor_title'])
                                <div class="ser">
                                    <div class="ser-logo">
                                        <img src={{ url('assets/imgs/ser2.png') }} alt="Ranking">
                                    </div>
                                    <div class="ser-content">
                                        <h2>{{ $details['second_factor_title'] }}</h2>
                                        <div>{{ $details['second_factor_desc'] }}</div>
                                    </div>
                                </div>
                            @endif

                            @if ($details['third_factor_title'])
                                <div class="ser">
                                    <div class="ser-logo">
                                        <img src={{ url('assets/imgs/ser3.png') }} alt="Downloads">
                                    </div>
                                    <div class="ser-content">
                                        <h2>{{ $details['third_factor_title'] }}</h2>
                                        <div>{{ $details['third_factor_desc'] }}
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if ($details['fourth_factor_title'])
                                <div class="ser">
                                    <div class="ser-logo">
                                        <img src={{ url('assets/imgs/ser4.png') }} alt="Endorsment">
                                    </div>
                                    <div class="ser-content">
                                        <h2>{{ $details['fourth_factor_title'] }}</h2>
                                        <div>{{ $details['fourth_factor_desc'] }}
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="brands dotted-bg">
            <h1 class="text-center" style="padding-top: 40px;">Gallery</h1>
            <div class="container">
                @foreach (json_decode($details['images']) as $img)
                    <div class="row brand-img">
                        <div class="col-lg-12">
                            <div class="item">
                                <div class="slider-container"><img src={{ url('storage/' . $img) }} alt="brand-images">
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>


        <section id="contact" class="contact dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center lets-connect">
                            <div class="contact-small"></div>
                            <h2><span class="outlined">Let's</span></h2>
                            <h3><span class="">Connect</span></h3>
                            <a class="reded" href={{ url('contact#contact') }}>Get In Touch</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endsection
