@extends('layout')
@section('title', 'About')
@section('description', $contact['description'])
@section('keywords', 'email, phone, address')
@section('content')
    <main>
        <section class="services dotted-bg lets-connect about" id="about">
            <div class="banner-text in-sections text-center">
                <div class="outlined appear-case"><span style="opacity: 0">Spacetoon</span></div>
                <div class="appear-case"><span style="opacity: 0">LICENSING</span></div>
            </div>

            <div class="banner-text in-sections text-center about-text">
                {{ $contact['description'] }}</div>

            <div class="banner-text in-sections text-center about-text text-uppercase title">
                How our audience feel about us
            </div>

            <video class="about-video" controls>
                <source src={{ url('storage/' . json_decode($contact['video'])[0]->download_link) }} type="video/mp4">
            </video>
        </section>
        <section class="services dotted-bg lets-connect" id="contact">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 relative">
                        <div class="banner-text in-sections text-center extra-size">
                            <span class="small">Contact</span>
                            <div class="outlined appear-case"><span style="opacity: 0">LET'S</span></div>
                            <div class="appear-case"><span style="opacity: 0">TALK</span></div>
                        </div>


                    </div>
                    <div class="col-lg-6 ">
                        <div class="d-flex the-events-menu"
                            style="padding-top:80px;
                        padding-bottom:0px;">
                            <div>
                                <span>
                                    Our Working Days
                                </span>
                                <span>
                                    {{ $contact->working_days }}
                                </span>
                            </div>
                            <div>
                                <span>
                                    Our Working Hours
                                </span>
                                <span>
                                    {{ $contact->working_hours }}
                                </span>
                            </div>
                        </div>
                        <div class="social" style="margin-top:50px;
                        margin-left:165px;">
                            <ul class="list-unstyled">
                                <li>
                                    <a href={{ 'mailto: ' . $contact->email }}>
                                        <div class="col-4" style="margin-left:40px">
                                            <i class="fa fa-envelope-o"></i>
                                        </div>
                                        <div class="col-4" style="margin-left:8px"></div>
                                        <div class="col-4" style="margin-left:8px">
                                            <span>{{ $contact['email'] }}</span>
                                        </div>
                                    </a>
                                </li>
                                <li>
                                    <a href={{ 'Tel: ' . $contact->phone }}>
                                        <div class="col-4" style="margin-left:40px">
                                            <i class="fa fa-phone"></i>
                                        </div>
                                        <div class="col-4" style="margin-left:8px"></div>
                                        <div class="col-4" style="margin-left:8px">
                                            <span>{{ $contact['phone'] }}</span>
                                        </div>
                                    </a>
                                </li>
                                <li>
                                    <a href="#">
                                        <div class="col-4" style="margin-left:40px">
                                            <i class="fa fa-home"></i>
                                        </div>
                                        <div class="col-4" style="margin-left:8px"></div>
                                        <div class="col-4" style="margin-left:8px">
                                            <span>{{ $contact['address'] }}</span>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endsection
