@extends('layout')
@section('title', 'home')
@section('description', 'Creating captivating product licensing concepts')
@section('keywords')
    {!! $keyWords !!}
@endsection
@section('content')
    <header>
        <div class="custom-paralaxed-container relative">
            <div class="banner-text text-center">
                <span class="appear-case"><span style="opacity: 0">Spacetoon</span></span> <span
                    class="outlined appear-case case2"><span style="opacity: 0">LICENSING</span></span>
            </div>
            <div class="custom-paralaxed">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-4 img-col first-col">
                            @for ($i = 0; $i < 2; $i++)
                                <video class="img" autoplay loop muted {{-- poster={{ url('storage/' . $brands[$i]['main_image']) }} --}}>
                                    <source
                                        src={{ url('storage/' . json_decode($videos[$i]['video'])[count(json_decode($videos[$i]['video'])) - 1]->download_link) }}
                                        type="video/mp4">
                                </video>
                            @endfor
                        </div>

                        <div class="col-md-4 img-col secondthird-col">
                            @for ($i = 2; $i < 4; $i++)
                                <video class="img" autoplay loop muted {{-- poster={{ url('storage/' . $brands[$i]['main_image']) }} --}}>
                                    <source
                                        src={{ url('storage/' . json_decode($videos[$i]['video'])[count(json_decode($videos[$i]['video'])) - 1]->download_link) }}
                                        type="video/mp4">
                                </video>
                            @endfor
                        </div>
                        <div class="col-md-4 img-col third-col">
                            @for ($i = 4; $i < 6; $i++)
                                <video class="img" autoplay loop muted {{-- poster={{ url('storage/' . $brands[$i]['main_image']) }} --}}>
                                    <source
                                        src={{ url('storage/' . json_decode($videos[$i]['video'])[count(json_decode($videos[$i]['video'])) - 1]->download_link) }}
                                        type="video/mp4">
                                </video>
                            @endfor
                        </div>
                    </div>
                </div>
            </div>
            <div class="black-opacity"></div>

        </div>
    </header>

    <main>
        <section class="under-parallaxed-vids">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <h1 data-aos="fade-up" data-aos-delay="10">Creating
                            captivating product licensing concepts to take your brand to the next level
                        </h1>
                    </div>
                </div>
            </div>
        </section>
        <section class="brands-logos dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="logo-title" data-aos="fade-down" data-aos-delay="200">
                            Our Retail Partners
                        </div>
                    </div>
                    <div class="col-lg-9">
                        <div id="logo-bar" class="logo-bar owl-carousel owl-theme">
                            @foreach ($partners as $partner)
                                <div class="item">
                                    <div class="icon-container"><img src={{ url('storage/' . $partner['logo']) }}
                                            alt="Partners Logos"></div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="services dotted-bg" id="services">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 relative">
                        <div class="banner-text in-sections text-center cus-sticky">
                            <div class="outlined appear-case"><span style="opacity: 0">Spacetoon</span></div>
                            <div class="outlined appear-case"><span style="opacity: 0">LICENSING</span></div>
                            <div class="appear-case"><span style="opacity: 0">Services</span></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="services">
                            @foreach ($services as $service)
                                <div class="ser">
                                    <div class="ser-logo">
                                        <img src={{ url('storage/' . $service->image) }} alt="Product Licensing">
                                    </div>
                                    <div class="ser-content">
                                        <h2>{{ $service->title }}</h2>
                                        <div>{{ $service->description }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="services dotted-bg ">
            <h1 class="text-center" style="padding-top: 40px;">OUR BRANDS</h1>
            <div class="pt-5 pb-3"></div>

            <div class="container brangs-sec-title">
                <div class="row">
                    @if ($priorityBrands->count() % 2 == 0)
                        @foreach ($priorityBrands as $brand)
                            <div class="col-lg-6">
                                <div class="brand-screen appear-case" style="opacity: 0;">
                                    <a href={{ url('brand/' . $brand['id']) }}><img
                                            src={{ url('storage/' . $brand['image_for_home']) }}
                                            alt="{{ $brand['name'] }}">
                                        <span class="view-more" value="5">View More</span>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    @else
                        @foreach ($priorityBrandsWithoutLast as $brand)
                            <div class="col-lg-6">
                                <div class="brand-screen appear-case" style="opacity: 0;">
                                    <a href={{ url('brand/' . $brand['id']) }}><img
                                            src={{ url('storage/' . $brand['image_for_home']) }}
                                            alt="{{ $brand['name'] }}">
                                        <span class="view-more" value="5">View More</span>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                        <div class="col-lg-12">
                            <div class="brand-screen appear-case" style="opacity: 0;">
                                <a href={{ url('brand/' . $lastBrand['id']) }}>
                                    <img src={{ url('storage/' . $lastBrand['image_for_home']) }}
                                        alt="{{ $lastBrand['name'] }}">
                                    <span class="view-more" value="5">View More</span>
                                </a>
                            </div>
                        </div>
                    @endif

                    <div class="col-lg-12 pt-4">
                        <div class="brand-see-all underlined text-center appear-case">
                            <a href={{ url('ourbrands') }}>See All Brands</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pt-5 pb-3"></div>
        </section>

        <section class="services footprint dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="banner-text cus-sticky in-sections text-center">
                            <div class="outlined"><span class="appear-case"><span style="opacity: 0">SPACETOON</span></span>
                            </div>
                            <div><span class="appear-case"><span style="opacity: 0">Footprint</span></span></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="services">
                            <div class="ser">
                                <div class="ser-logo">
                                    <img src={{ URL::asset('assets/imgs/cocial-icon/youtube.png') }}
                                        alt="Subscriptions on Youtube">
                                </div>
                                <div class="ser-content" id="subCount">
                                    <h2>
                                        {{-- 8 --}}
                                        {{ $count['youtube_sub'] }}
                                        SUBS ON YOUTUBE</h2>
                                </div>
                            </div>
                            <div class="ser">
                                <div class="ser-logo">
                                    <img src={{ URL::asset('assets/imgs/cocial-icon/instagram.png') }}
                                        alt="Instagram followers">
                                </div>
                                <div class="ser-content">
                                    <h2>
                                        {{ $count['insta_followers'] }}
                                        {{-- 2 --}}
                                        INSTAGRAM FOLLOWERS</h2>
                                </div>
                            </div>
                            <div class="ser">
                                <div class="ser-logo">
                                    <img src={{ URL::asset('assets/imgs/cocial-icon/facebook.png') }}
                                        alt="Facebook followers">
                                </div>
                                <div class="ser-content">
                                    <h2>
                                        {{ $count['face_followers'] }}
                                        {{-- 2 --}}
                                        FACEBOOK FOLLOWERS</h2>
                                </div>
                            </div>
                            <div class="ser">
                                <div class="ser-logo">
                                    <img src={{ URL::asset('assets/imgs/cocial-icon/viewers.png') }} alt="Viewers">
                                </div>
                                <div class="ser-content">
                                    <h2>
                                        {{ $count['monthly_viewers'] }}
                                        {{-- 160 --}}
                                        MONTHLY VIEWERS</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pt-3 pb-3"></div>
        </section>

        <section id="contact" class="contact dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center lets-connect">
                            <div class="contact-small"></div>
                            <h2><span class="outlined">Let's</span></h2>
                            <h3><span>Connect</span></h3>
                            <a class="reded" href={{ url('contact#contact') }}>Get In Touch</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endsection
