<!doctype html>
<html class="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ __('Spacetoon Licensing') }} | @yield('title')</title>
    <meta name="keywords" content="@yield('keywords')">
    <meta name="description" content="@yield('description')">
    <link rel="icon" type="image/x-icon" href={{ URL::asset('assets/imgs/SpacetoonLicensing2.svg') }}>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.3/css/bootstrap.min.css"
        integrity="sha512-SbiR/eusphKoMVVXysTKG/7VseWii+Y3FdHrt0EpKgpToZeemhqHeZeLWLhJutz/2ut2Vw1uQEj2MbRF+TVBUA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
        integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css"
        integrity="sha512-1cK78a1o+ht2JcaW6g8OXYwqpev9+6GqOkz9xmBN9iUUhIndKtxwILGWYOSibOKjLsEdjyjZvYDq/cZwNeak0w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel=" stylesheet" href={{ url('assets/fonts/satoshi/css/satoshi.css') }}>
    <link rel=" stylesheet" href={{ url('assets/fonts/clash/css/clash-display.css') }}>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css"
        integrity="sha512-UTNP5BXLIptsaj5WdKFrkFov94lDx+eBvbKyoe1YAfjeRPC+gT5kyZ10kOHCfNZqEui1sxmqvodNUx3KbuYI/A=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel=" stylesheet" href={{ url('assets/css/style.css') }}>

<body class="en">
    <div id="cursor">
        <div class="curs-circle"></div>
    </div>

    <div class="wrapper">
        <div class="navbar-container dotted-bg">

            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a class="navbar-brand" href={{ url('index') }}><img
                            src={{ URL::asset('assets/imgs/SpacetoonLicensing.svg') }} alt="SpacetoonLicensingLogo"></a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar"
                        aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                        aria-labelledby="offcanvasNavbarLabel">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel"><img
                                    src={{ URL::asset('assets/imgs/SpacetoonLicensing.svg') }}
                                    alt="SpacetoonLicensingLogo"></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                                aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body">
                            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                                <li class="nav-item">
                                    <a class="nav-link active" aria-current="page" href={{ url('ourbrands') }}>Our
                                        Brands</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href={{ url('index#services') }}>Services</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href={{ url('contact#about') }}>About</a>
                                </li>
                                @if ($news->count() > 0)
                                    <li class="nav-item">
                                        <a class="nav-link" href={{ url('new') }}>News</a>
                                    </li>
                                @endif
                                <li class="nav-item">
                                    <a class="nav-link featured" href={{ url('contact#contact') }}>Get in Touch</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>

        </div>
        @yield('content')
        <footer class="wrapp-overflow dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="footer-1">
                            <img class="footer-logo" src={{ URL::asset('assets/imgs/SpacetoonLicensing.svg') }}
                                alt="SpacetoonLicensingLogo">
                            <h3 class="syne">Spacetoon Licensing</h3>
                            <a href="" style="display: inline-flex;">
                                <div class="col-2">
                                    <i class="fa fa-home"></i>
                                </div>
                                <div class="col-4" style="width:auto;">
                                    <span>{{ $contact['address'] }}</span>
                                </div>
                                <div class="col-4"></div>
                                <div class="col-2"></div>
                            </a>


                            <div class="social">
                                <ul class="list-unstyled">
                                    <li>
                                        <a href="#">
                                            <i class="fa fa-linkedin"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="footer-2">
                            <ul class="list-unstyled links">
                                <li class="underlined2">
                                    <a href={{ url('contact#about') }}>
                                        About us
                                    </a>
                                </li>
                                <li class="underlined2">
                                    <a href={{ url('index#services') }}>
                                        Our services
                                    </a>
                                </li>
                                @if ($news->count() > 0)
                                    <li class="underlined2">
                                        <a href={{ url('new') }}>
                                            News
                                        </a>
                                    </li>
                                @endif
                                <li class="">
                                    <a class="blued" href={{ url('contact#contact') }}>
                                        Contact us
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="footer-3">
                            <ul class="list-unstyled links">
                                <li class="underlined2">
                                    <a href={{ url('ourbrands') }}>
                                        Brands:
                                    </a>
                                </li>
                                @foreach ($priorityBrands as $brand)
                                    <li class="underlined2">
                                        <a href={{ url('brand/' . $brand['id']) }}>
                                            {{ $brand['name'] }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="copyrights">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="cr">
                                © 2023 All Rights reserved.
                            </div>
                        </div>
                        <div class="col-md-6">
                        </div>
                    </div>
                </div>
            </div>
        </footer>

        </main>

    </div>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.3/js/bootstrap.bundle.min.js"
        integrity="sha512-i9cEfJwUwViEPFKdC1enz4ZRGBj8YQo6QByFTF92YXHi7waCqyexvRD75S5NVTsSiTv7rKWqG9Y5eFxmRsOn0A=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"
        integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
        integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"
        integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
        integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        AOS.init({
            easing: 'ease-in-out',
            duration: 1000,
            offset: 100,
            duration: 1400,
            delay: 300
        });

        $(".banner-slider").owlCarousel({
            loop: true,
            nav: false,
            margin: 0,
            dots: false,
            items: 1,
            mouseDrag: false,
            animateIn: "fadeIn",
            animateOut: "fadeOut",
            autoplay: true
        });
    </script>
    <script src={{ URL::asset('assets/js/custom.js') }}></script>


    <script>
        // Get Subscribers
        const youtubeKey = 'AIzaSyBrov_itkxQHF5OVZpwZ40jy8hGAwyyqUU';
        const youtubeUser = 'RuuXzTIr0OoDqI4S0RU6n4FqKEM';
        const subCount = document.getElementById('subCount');

        let getSubscribers = () => {

            fetch(`https://www.googleapis.com/youtube/v3/channels?part=statistics&id=${youtubeUser}&key=${youtubeKey}`)
                .then(response => {
                    return response.json()
                })
                .then(data => {
                    console.log(data);
                    subCount.innerHTML = data["items"][0].statistics.subscriberCount;
                })

        }
        getSubscribers();
    </script>

    {{-- Instagram --}}
    <script>
        const accessToken = 'YOUR_ACCESS_TOKEN';
        const username = 'SpacetoonInstagram';

        fetch(`https://graph.instagram.com/${username}?fields=id&access_token=${accessToken}`)
            .then(response => response.json())
            .then(data => {
                const userId = data.id;
                console.log('Instagram user ID:', userId);
            })
            .catch(error => {
                console.error('Error:', error);
            });
    </script>

    {{-- Facebook --}}
    <script>
        const accessToken = 'YOUR_ACCESS_TOKEN';
        const pageUsername = 'SpacetoonFacebook';

        fetch(`https://graph.facebook.com/${pageUsername}?fields=id&access_token=${accessToken}`)
            .then(response => response.json())
            .then(data => {
                const pageId = data.id;
                console.log('Facebook page ID:', pageId);
            })
            .catch(error => {
                console.error('Error:', error);
            });
    </script>
</body>

</html>
