@extends('layout')
@section('title', 'Our Brands')
@section('keywords')
    {!! $keyWords !!}
@endsection
@section('content')
    <main>
        <section class="services dotted-bg ">
            <div class="text-center center-title">
                <h1>BRANDS</h1>
                <ul class="nav nav-tabs" id="myTab" role="tablist">

                    <div class="tags-style unter-title">
                        <a class="nav-link active" id="all-tab" data-bs-toggle="tab" data-bs-target="#all-tab-pane"
                            role="tab" aria-controls="all-tab-pane" aria-selected="true">
                            <span>All brands</span>
                        </a>
                        <a class="nav-link" id="preschool-tab" data-bs-toggle="tab" data-bs-target="#preschool-tab-pane"
                            role="tab" aria-controls="preschool-tab-pane" aria-selected="true">
                            <span>Pre school</span>
                        </a>
                        <a class="nav-link" id="teeens-tab" data-bs-toggle="tab" data-bs-target="#teens-tab-pane"
                            role="tab" aria-controls="teeens-tab-pane" aria-selected="false">
                            <span>Teens</span>
                        </a>
                        <a class="nav-link" id="anime-tab" data-bs-toggle="tab" data-bs-target="#anime-tab-pane"
                            role="tab" aria-controls="anime-tab-pane" aria-selected="false">
                            <span>Anime</span>
                        </a>
                    </div>
                </ul>
                <div class="row">
                    <div class="tab-content" id="myTabContent" data-aos="fade-up">
                        <div class="tab-pane fade show active" id="all-tab-pane" role="tabpanel" aria-labelledby="all-tab"
                            tabindex="0">
                            <div class="row img-section">
                                @foreach ($brands as $brand)
                                    <div class="col-lg-12">
                                        <div class="brand-screen appear-case" style="opacity: 0;">
                                            <a href={{ url('brand/' . $brand->id) }}>
                                                <img src={{ url('storage/' . $brand['main_image']) }}
                                                    alt="{{ $brand['name'] }}">
                                                <span class="view-more" value="5">View More</span>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="tab-pane fade show active" id="preschool-tab-pane" role="tabpanel"
                            aria-labelledby="preschool-tab" tabindex="0">
                            <div class="row img-section">
                                @foreach ($preschoolBrands as $brand)
                                    <div class="col-lg-12">
                                        <div class="brand-screen appear-case" style="opacity: 0;">
                                            <a href={{ url('brand/' . $brand->id) }}>
                                                <img src={{ url('storage/' . $brand['main_image']) }}
                                                    alt="{{ $brand['name'] }}">
                                                <span class="view-more" value="5">View More</span>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="tab-pane fade" id="teens-tab-pane" role="tabpanel" aria-labelledby="teeens-tab"
                            tabindex="0">
                            <div class="row img-section">
                                @foreach ($teensBrands as $brand)
                                    <div class="col-lg-12">
                                        <div class="brand-screen appear-case" style="opacity: 0;">
                                            <a href={{ url('brand/' . $brand->id) }}>
                                                <img src={{ url('storage/' . $brand['main_image']) }}
                                                    alt="{{ $brand['name'] }}">
                                                <span class="view-more" value="5">View More</span>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="tab-pane fade" id="anime-tab-pane" role="tabpanel" aria-labelledby="anime-tab"
                            tabindex="0">
                            <div class="row">
                                @foreach ($animeBrands as $brand)
                                    <div class="col-lg-12">
                                        <div class="brand-screen appear-case" style="opacity: 0;">
                                            <a href={{ url('brand/' . $brand->id) }}>
                                                <img src={{ url('storage/' . $brand['main_image']) }}
                                                    alt="{{ $brand['name'] }}">
                                                <span class="view-more" value="5">View More</span>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <section id="contact" class="contact dotted-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center lets-connect">
                            <div class="contact-small"></div>
                            <h2><span class="outlined">Let's</span></h2>
                            <h3><span class="">Connect</span></h3>
                            <a class="reded" href={{ url('contact') }}>Get In Touch</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endsection
